;----------------------------------------------------------
;
;	RASTERS
;	VIC 20 Unexpanded
;
;	by Aleksi Eeben for Lovebyte 2022 / 128 Byte
;
;----------------------------------------------------------


sinpos	equ	$02
bars	equ	$03
dist	equ	$04


	processor 6502

	org	$1400

go
	sei

;	ldy	#$00		; y is zero after sys (from $030e if not modified after reset)
	ldx	#$1f
.1
	lda	sine,x		; build sine table
	sta	sine+$20,y
	eor	#$ff
	sta	sine+$40,x
	sta	sine+$60,y
	iny
	dex
	bpl	.1

loop
	inc	sinpos		; move sine

	lda	#12		; number of bars
	sta	bars

.nextbar
	sta	dist
	adc	sinpos
	and	#$7f
	tax
	lda	sine,x
	adc	#$89
	tax
	txs

	ldy	#$0b		; draw bar to stack
.3
	lda	color,y
	pha
	dey
	bpl	.3

	lda	dist
	adc	#$02
	dec	bars
	bne	.nextbar

	ldx	#$26
	txs
.wait
	cpx	$9004
	bne	.wait

.colors
	pla
	sta	$900f

	ldy	#11
.2
	dey
	bne	.2

	inx
	cpx	#$de
	bne	.colors

	beq	loop


color
	dc.b	$68,$48,$e8,$38,$b8,$18,$18
	dc.b	$f8,$78,$98,$88,$28

sine
	INCBIN	"sin.bin"	; 1 quarter of sine, see binary
